import os
import sys
import subprocess
import multiprocessing
import threading
import time
import numpy as np
import pandas as pd
sys.path.append(os.environ['HPDMFLEX'])
from pyHPDM.api import HPDMInstance, HPDMInput,HPDMOutput, NAt

generate_new_data = True

Current_path = os.getcwd()
HPDMfiles_path = '../HPDMfiles'
Datafiles_path = '../Data'
DataTable_root = '../data/HPMap'
GridInputs_path = '../data/GridInputs.csv'
DataTable_path_Ini = '../data/HPMapIni.csv'
DataTable_path_Final = '../data/HPMap.csv'
HPDMTable_path_Ini = '../data/MapIni.dat'
HPDMTable_path_Final = '../data/MapBak.dat'

if os.path.exists(DataTable_path_Ini):
    os.remove(DataTable_path_Ini)

if os.path.exists(DataTable_path_Final):
    os.remove(DataTable_path_Final)

if os.path.exists(HPDMTable_path_Ini):
    os.remove(HPDMTable_path_Ini)

if os.path.exists(HPDMTable_path_Final):
    os.remove(HPDMTable_path_Final)

Dim_GridVars = 6
Dim_LookupVars = 4

#test HPDM instance
str1 = "SystemConfig.dat"
iRunMode = 0
iPrintFlg = 0
iObjID = 0 
iDebug = 0
        
#raise HPDM instance
VRF_ID = HPDMInstance(str1, iObjID, iRunMode, iPrintFlg, iDebug)

#identify input variables
iCompID = 2
Var_SupH_i =  HPDMInput(iCompID, NAt.V, 21, 0.0) #coil exit superheat degree

iCompID = 0
Var_LiqT_i =  HPDMInput(iCompID, NAt.V, 2, 0.0) #entering liquid temperature
        
iCompID = 4
Var_Tevap_i =  HPDMInput(iCompID, NAt.V, 1, 0.0) #evaporatoing temperature

iCompID = 1
Var_AirFV_i =  HPDMInput(iCompID, NAt.V, 4, 0.0) #volumetric air flow rate 

iCompID = 2
Var_Tair_i =  HPDMInput(iCompID, NAt.V, 15, 0.0) #indoor coil inlet temperature

iCompID = 2
Var_RHair_i =  HPDMInput(iCompID, NAt.V, 33, 0.0) #indoor coil inlet relative humidity

#guessed variable
iCompID = 2
Var_TsatCoil_g =  HPDMInput(iCompID, NAt.V, 0, 0.0) #coil inlet saturation temperature, guess value

#indentify output variables
iCompID = 1
Var_FANPOW_o =  HPDMOutput(iCompID, 5)
iCompID = 2
Var_TotCapacity_o =  HPDMOutput(iCompID, 20)
iCompID = 2
Var_SHR_o =  HPDMOutput(iCompID, 22)
iCompID = 2
Var_Mr_o =  HPDMOutput(iCompID, 3)


if generate_new_data == True:

    if os.path.exists(GridInputs_path):
        os.remove(GridInputs_path)
    
    column_features = ['Superheat Grade (-)',
                    'Liquid T (F)', 
                   'Evap T (F)',
                   'Indoor Air Flow (ft^3/hr)',
                   'Indoor T (F)',
                   'Indoor RH (-)']

     # Create a list to hold the patterned inputs
    SupGrad = np.array([1, 2, 3, 4, 5])
    LiqTF  = np.array([60.0, 70.0, 80.0, 90.0, 100.0, 110.0, 120.0, 130.0])
    EvapTF = np.array([35.0, 40.0, 45.0, 50.0, 55.0])
    IndAirV = np.array([12000.0, 18000.0, 24000.0, 30000.0, 36000.0])
    IndTF = np.array([65.0, 70.0, 75.0, 80.0, 85.0])
    IndRH = np.array([0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8])
    
    df1 = pd.DataFrame(columns = column_features[:1], data = SupGrad)
    df2 = pd.DataFrame(columns = column_features[1:2], data = LiqTF)
    df3 = pd.DataFrame(columns = column_features[2:3], data = EvapTF)
    df4 = pd.DataFrame(columns = column_features[3:4], data = IndAirV)
    df5 = pd.DataFrame(columns = column_features[4:5], data = IndTF)
    df6 = pd.DataFrame(columns = column_features[5:6], data = IndRH)

    df = df1.merge(df2,how='cross').merge(df3,how='cross').\
        merge(df4,how='cross').merge(df5,how='cross').merge(df6,how='cross')
    df = df.astype('float')
    df.to_csv(GridInputs_path)    
else:
    df = pd.read_csv(GridInputs_path,index_col=0)


def save_file(i,SupGrad, LiqTF, EvapTF, IndAirV, IndTF, IndRH,  \
            FANPOW,TotCapacity,SHR, Mr, Status):
    try:
        Thread_ID = threading.get_ident()
        FANPOW=np.array(FANPOW)
        TotCapacity=np.array(TotCapacity)
        SHR=np.array(SHR)
        Mr=np.array(Mr)
        
        SupGrad = np.array(SupGrad)
        LiqTF = np.array(LiqTF)
        EvapTF = np.array(EvapTF)
        IndAirV = np.array(IndAirV)
        IndTF = np.array(IndTF)
        IndRH = np.array(IndRH)
        
    
        A =pd.concat((pd.Series(SupGrad),pd.Series(LiqTF),pd.Series(EvapTF),pd.Series(IndAirV),pd.Series(IndTF),pd.Series(IndRH),\
                      pd.Series(FANPOW),pd.Series(TotCapacity), pd.Series(SHR),pd.Series(Mr),\
                      pd.Series(Status)),axis=1)
        A.index = [i]

        SaveThread = "{} {} {}".format(DataTable_root, Thread_ID, '.hpdmout')    
        if os.path.exists(SaveThread):
            A.to_csv(SaveThread,mode='a',header=False)
        else:
            #A.to_csv(SaveThread,mode='w',header=True)
            A.to_csv(SaveThread,mode='w',header=False)
    except Exception as e:
        print(f"An error occurred while saving row {i}: {e}")
    
    return


def process_row(i, cols):
    try:
        os.chdir(HPDMfiles_path)
        SupGradi = []
        LiqTFi  = []
        EvapTFi = []
        IndAirVi = []
        IndTFi = []
        IndRHi = []

        FANPOWo = []
        TotCapacityo = []
        SHRo = []
        Mro = []
        Status = []
        
        #transfer data array to HPDM input variables
        Var_LiqT_i.Value =  cols.iloc[1] #entering liquid temperature
        LiqTFi.append(Var_LiqT_i.Value)
        Var_Tevap_i.Value =  cols.iloc[2] #evaporatoing temperature
        EvapTFi.append(Var_Tevap_i.Value)
        Var_AirFV_i.Value =  cols.iloc[3] #volumetric air flow rate 
        IndAirVi.append(Var_AirFV_i.Value)
        Var_Tair_i.Value =  cols.iloc[4] #indoor coil inlet temperature
        IndTFi.append(Var_Tair_i.Value)
        Var_RHair_i.Value =  cols.iloc[5] #indoor coil inlet relative humidity
        IndRHi.append(Var_RHair_i.Value)
        Var_TsatCoil_g.Value =  Var_Tevap_i.Value + 2.0 #coil inlet saturation temperature, guess value
        #convert superheat grade to superheat value
        Var_SupH_i.Value = ((Var_Tair_i.Value- 1.0)-(Var_Tevap_i.Value +5.0))/4.0*(cols.iloc[0]-1)+5.0
        SupGradi.append(cols.iloc[0])
               
        #transfer inputs to the simulation engine
        VRF_ID.IN(Var_SupH_i)
        VRF_ID.IN(Var_LiqT_i)
        VRF_ID.IN(Var_Tevap_i)
        VRF_ID.IN(Var_AirFV_i)
        VRF_ID.IN(Var_Tair_i)
        VRF_ID.IN(Var_RHair_i)
        VRF_ID.IN(Var_TsatCoil_g)
                
        #execuate the simulation for one run
        iErr = VRF_ID.RUN()

        #save output variables
        FANPOWo.append(VRF_ID.OUT(Var_FANPOW_o))
        TotCapacityo.append(VRF_ID.OUT(Var_TotCapacity_o)*-1.0)
        SHRo.append(VRF_ID.OUT(Var_SHR_o))
        Mro.append(VRF_ID.OUT(Var_Mr_o))

        if iErr == -1:
            Status.append('F') #failed runs
        elif iErr == 1:
            Status.append('W') #with warning
        else:
            Status.append('P') #successful runs            
        
        save_file(i,SupGradi, LiqTFi, EvapTFi, IndAirVi, IndTFi, IndRHi,  \
            FANPOWo,TotCapacityo,SHRo, Mro, Status)
    
    except Exception as e:
        print(f"An error occurred while processing row {i}: {e}")

    
# Function to find unique numbers in ascending order for a Series
def unique_sorted(series):
    # Filter out non-numeric values
    numeric_series = series[pd.to_numeric(series, errors='coerce').notna()]
    
    # Get unique numbers and sort them in ascending order
    return sorted(numeric_series.unique())
     
if __name__ == "__main__":
    time0 = time.time()
    pool = multiprocessing.Pool()

    # rows below for debugging with shorter section
    #for i, cols in df.iloc[:100].iterrows():
    for i, cols in df.iterrows():
        #process_row(i, cols) #debug into
        pool.apply_async(process_row, args=(i, cols))
        time.sleep(0.01)  # Add a small delay between starting each process
    # the codes below may duplicate some rows
    # with multiprocessing.Pool() as pool:
    #      pool.starmap(process_row, [(i, cols) for i, cols in df.iterrows()])
    #      time.sleep(0.01)  # Add a small delay between starting each process
    
    pool.close()
    pool.join()

    time1 = time.time()
    with open('../Data/process_time.txt','w') as file:
        file.write(str(time1-time0)) #seconds

    #time.sleep(10)
    os.chdir(Datafiles_path)

    # merge the data tables from multi-threading 
    # Dictionary to hold lists of DataFrames by basename
    files_by_basename = {}

# Iterate over files in the directory
    for filename in os.listdir(Datafiles_path):
    # Split the filename into basename and extension
        basename, ext = os.path.splitext(filename)
    
        # We'll only merge files with the hpdmout extension
        if ext == '.hpdmout':
            full_path = os.path.join(Datafiles_path, filename)

            # If the basename is not already in the dictionary, initialize it
            if basename not in files_by_basename:
                files_by_basename[basename] = []
        
            # Read the CSV file and append the DataFrame to the list
            df = pd.read_csv(full_path)
            files_by_basename[basename].append(df)

# Merge DataFrames with the same basename and save them to new files
    empty_array = np.empty((0, Dim_GridVars + Dim_LookupVars + 1))

    for basename, dfs in files_by_basename.items():
        if len(dfs) > 0:  # Only merge if there's more than one row
            merged_df = pd.read_csv(basename + '.hpdmout')  
            if os.path.exists(DataTable_path_Ini):
                merged_df.to_csv(DataTable_path_Ini, mode='a', index = False)
            else:
                merged_df.to_csv(DataTable_path_Ini, mode='w', index = False)
            os.remove(basename + '.hpdmout')


    #rank the rows by index column
    dTable = pd.read_csv(DataTable_path_Ini, header=None)
    dTable.columns = ['No', 'SupGrad', 'LiqTF', 'EvapTF','IndAirV', 'IndTF', 'IndRH', \
        'FANPOW', 'TotCapacity','SHR','Mr','Status']

    # Sort the data by the first column (excluding the header)
    ranked_data = dTable.sort_values(by=dTable.columns[0])

    # Resetting the index for better readability
    ranked_data.reset_index(drop=True, inplace=True)

    ranked_data.to_csv(DataTable_path_Ini, index=False)

    #smooth and expand to full table by filling in missing and failed runs
    columns_to_process = ranked_data.columns[1:(Dim_GridVars+1)]

    # Collect unique numbers for each specified column
    results = {col: unique_sorted(ranked_data[col]) for col in columns_to_process}

    # Print results for each column
    for column, unique_numbers in results.items():
        print(f"Unique numbers in column '{column}': {unique_numbers}")

    with open(HPDMTable_path_Ini,'w') as file:
        file.write(str(Dim_LookupVars) + '\t' + '1' + '\n') 
        file.write('1' + '\n') 
        for number in range(10):
            file.write('10' + '\t') 
        file.write('\n') 

        ColCount = 0
        for unique_numbers in reversed(results.items()):
            length = len(unique_numbers[1])
            file.write(str(length) + '\t')
            ColCount = ColCount + 1

        while ColCount < 10:
            file.write('1' + '\t') 
            ColCount = ColCount + 1
        file.write('\n') 

        ColCount = 1
        for unique_numbers in reversed(results.items()):
            file.write(str(ColCount) + '\t') 
            # Write the numbers as a single row separated by tabs
            file.write('\t'.join(map(str, unique_numbers[1])) + '\n')  # Add a newline at the end
            ColCount = ColCount + 1

        for unique_numbers in reversed(results.items()):
            file.write(unique_numbers[0] + '\t') 
        
        headers_Lookup_Vars = ranked_data.columns[(Dim_GridVars+1):(Dim_GridVars+1+Dim_LookupVars)]  # This selects 'Column 7' to 'Column 13'
    
        # Write the selected headers to the file
        file.write('\t'.join(headers_Lookup_Vars) + '\n')  # Join headers with tabs and add a newline

        for index, row in ranked_data.iterrows():
            if row['Status'] != 'F':
                # Select columns 7 to 1 in reverse order
                col_GridVars = row[Dim_GridVars:0:-1]
                # Select columns 7 to 14
                col_LookupVars = row[(Dim_GridVars+1):(Dim_GridVars+1+Dim_LookupVars)]
                # Combine both selections
                combined_row = pd.concat([col_GridVars, col_LookupVars])
                # Write the combined values to the file as a tab-separated row
                file.write('\t'.join(map(str, combined_row.values)) + '\n')
        file.write('E')
    
    #massage the full table
    # Path to the executable
    exe_path = os.environ['HPDMFLEX'] + '/Bin/' + 'gTable.exe'  
    # Arguments to pass to the executable
    args = [HPDMTable_path_Ini, '3']  
    subprocess.run([exe_path] + args)

    dNewTable = []

    with open(HPDMTable_path_Final, 'r') as file:
        for line in file:
            # Remove any leading/trailing whitespace and split by space or another delimiter
            row = line.strip().split()  # Change the split argument if needed
            dNewTable.append(row)

    # Find the index of the first row that starts with "Status"
    index_of_status = next((i for i, row in enumerate(dNewTable) if row and row[0] == "Status"), None)

    # Remove rows ahead of the "Status" row if it exists
    if index_of_status is not None:
        dNewTable = dNewTable[index_of_status + 1:]  # Keep only rows from "Status" onwards
        print("\nData after deleting rows ahead of the 'Status' row:")
         # Remove the row starting with "E"
        dNewTable = [row for row in dNewTable if not (row and row[0].startswith("E"))]
    else:
        print("\nNo row starting with 'Status' found.")

    # Define new headers
    My_List = dTable.columns[(Dim_GridVars + 1) : (Dim_GridVars + 1 + Dim_LookupVars + 1) ] 
    
    new_headers=[]
    # Move the last member to the first position
    new_headers.append('Status')

    for item in My_List[0:-1]:
         new_headers.append(item)

    # Convert list to DataFrame
    df2_selected = pd.DataFrame(dNewTable, columns=new_headers)

    # Move the first column to the last position
    df2_selected = pd.concat([df2_selected.iloc[:, 1:], df2_selected.iloc[:, [0]]], axis=1)

    # input combination from ranked data
    df1_selected = ranked_data.iloc[:, 1:(Dim_GridVars+1)]  
 
    # Combine the two DataFrames
    combined_df = pd.concat([df1_selected.reset_index(drop=True), \
        df2_selected.reset_index(drop=True)], axis=1)
 
    # save the combined DataFrame to a new CSV file
    combined_df.to_csv(DataTable_path_Final, index=False)